	% EXAMPLE 5.14 Minimum-Phase FIR Filter
	%
	% 	Author: 		Lars Wanhammar 2005-06-26
	% 	Modified by: 	 
	% 	Copyright:		Divison of Electronics Systems
	% 					Dept. Electrical Engineering, Linkoping University, Sweden
	% 	Version:		1.0 
	% 	Known bugs:		None
	% 	Report bugs to:	Wanhammar@gmail.com
	
	wcT = 0.3*pi;	wsT = 0.6*pi;	dc = 0.02;	ds = 0.0025;
	Amax = 20*log10((1+dc)/(1-dc)),	Amin = 20*log10((1+dc)/ds)
	wTedges = [wcT wsT];	 
	N = MIN_PHASE_LP_FIR_ORDER(wTedges, [dc ds])
	
	[hMP, ZerosMP] = MIN_PHASE_LP_FIR(N, wTedges, [dc ds]);	
	wT = linspace(0, pi, 2000);		% wT axis 0 to  rad
	HMP = freqz(hMP, 1, wT);		% Frequency response
	Mag = H_2_MAG(HMP);				% Magnitude response [dB]
	Phase = angle(HMP);				% Phase response [rad]
	gd = grpdelay(hMP, 1, wT);		% Group delay [T]
	
	figure(1)
	PLOT_MAG_PZ_PHASE_TG_FIR(wT, wTedges, [dc ds], Mag, hMP, ZerosMP, Phase, gd)
	
	figure(2),	subplot(2,1,1)
	PLOT_IMPULSE_RESPONSE_Z(hMP)
	
	for n = 1:1998
		if angle(HMP(n+2)) > angle(HMP(n))
			n
			break
		end		
	end			
	n/2000
	
	angle(HMP(n+2)) 
	angle(HMP(n))
	
	
